/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.util.BinaryPersistenceWriter;
import frc.emul.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class AsciiPersistenceWriter
implements IPersistenceWriter {
    private static final byte[] CRLF = Utils.CRLF.getBytes();
    private final List<IPersistentSection> sections;
    private final OutputStream out;
    private final byte[] buffer;

    public static AsciiPersistenceWriter open(File file, boolean bl) throws PersistenceException {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            if (bl) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            return new AsciiPersistenceWriter(outputStream);
        }
        catch (Exception exception) {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Exception exception2) {}
            }
            throw new PersistenceException("File System", "Could not create the output file", exception);
        }
    }

    private AsciiPersistenceWriter(OutputStream outputStream) {
        this.out = outputStream;
        this.buffer = new byte[8];
        this.sections = new ArrayList<IPersistentSection>();
    }

    public void close() throws PersistenceException {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            throw new PersistenceException("File System", "Could not close the output file", iOException);
        }
    }

    private String getCurrentSectionPath() {
        return BinaryPersistenceWriter.getCurrentSectionPath(this.sections);
    }

    private void lineFeed() throws PersistenceException {
        int n = 0;
        while (n < CRLF.length) {
            this.emitByte(CRLF[n]);
            ++n;
        }
    }

    private void writeAscii(String string) throws PersistenceException {
        this.emitBytes(string.getBytes());
        this.lineFeed();
    }

    private void writeHexa(byte[] byArray, int n, int n2) throws PersistenceException {
        this.indent();
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3 + n];
            if (n3 > 0) {
                if (n3 % 32 == 0) {
                    this.lineFeed();
                    this.indent();
                } else {
                    this.emitByte(32);
                }
            }
            this.emitByte(Utils.DIGITS[by >> 4 & 0xF]);
            this.emitByte(Utils.DIGITS[by & 0xF]);
            ++n3;
        }
        this.lineFeed();
    }

    private void emitBytes(byte[] byArray) throws PersistenceException {
        this.emitBytes(byArray, 0, byArray.length);
    }

    private void emitBytes(byte[] byArray, int n, int n2) throws PersistenceException {
        this.indent();
        int n3 = 0;
        while (n3 < n2) {
            this.emitByte(byArray[n + n3]);
            ++n3;
        }
    }

    private void indent() throws PersistenceException {
        int n = this.sections.size();
        while (n-- > 0) {
            this.emitByte(9);
        }
    }

    private void emitByte(int n) throws PersistenceException {
        try {
            this.out.write(n);
        }
        catch (IOException iOException) {
            String string = this.getCurrentSectionPath();
            throw new PersistenceException(string, "Error while writing to the output file", iOException);
        }
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Method not supported by the Ascii writer");
    }

    public void closeSection() throws PersistenceException {
        IPersistentSection iPersistentSection = this.sections.remove(this.sections.size() - 1);
        if (iPersistentSection != null) {
            this.writeAscii("</" + iPersistentSection.getTag() + ">");
        }
    }

    public void openSection(IPersistentSection iPersistentSection) throws PersistenceException {
        if (iPersistentSection != null) {
            this.writeAscii("<" + iPersistentSection.getTag() + " id=\"$" + Utils.HEX4(iPersistentSection.getID()) + "\">");
        }
        this.sections.add(iPersistentSection);
    }

    public void write(IPersistentObject iPersistentObject) throws PersistenceException {
        IPersistentSection iPersistentSection = iPersistentObject.getSection();
        if (iPersistentSection != null) {
            this.openSection(iPersistentSection);
        }
        iPersistentObject.store(this);
        if (iPersistentSection != null) {
            this.closeSection();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws PersistenceException {
        this.writeHexa(byArray, n, n2);
    }

    public void write(boolean bl) throws PersistenceException {
        this.write8(bl ? 255 : 0);
    }

    public void write(float f) throws PersistenceException {
        this.write(Float.floatToRawIntBits(f));
    }

    public void write8(int n) throws PersistenceException {
        this.buffer[0] = (byte)n;
        this.writeHexa(this.buffer, 0, 1);
    }

    public void write16(int n) throws PersistenceException {
        this.buffer[0] = (byte)(n >>> 8);
        this.buffer[1] = (byte)n;
        this.writeHexa(this.buffer, 0, 2);
    }

    public void write(int n) throws PersistenceException {
        this.buffer[0] = (byte)(n >>> 24);
        this.buffer[1] = (byte)(n >>> 16);
        this.buffer[2] = (byte)(n >>> 8);
        this.buffer[3] = (byte)n;
        this.writeHexa(this.buffer, 0, 4);
    }

    public void write(long l) throws PersistenceException {
        this.buffer[0] = (byte)(l >>> 56);
        this.buffer[1] = (byte)(l >>> 48);
        this.buffer[2] = (byte)(l >>> 40);
        this.buffer[3] = (byte)(l >>> 32);
        this.buffer[4] = (byte)(l >>> 24);
        this.buffer[5] = (byte)(l >>> 16);
        this.buffer[6] = (byte)(l >>> 8);
        this.buffer[7] = (byte)l;
        this.writeHexa(this.buffer, 0, 8);
    }

    public void write(InputStream inputStream) throws PersistenceException {
        int n = 0;
        try {
            while (-1 != inputStream.read()) {
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new PersistenceException(this.getCurrentSectionPath(), "Error while copying input stream to the output file.", iOException);
        }
        this.writeAscii("<stream bytesCount=\"" + n + "\" />");
    }

    public void write(String string) throws PersistenceException {
        this.writeAscii("<cstring value=\"" + string + "\" />");
    }

    public void writeID(String string) throws PersistenceException {
        this.writeAscii("<id value=\"" + string + "\" />");
    }
}

